#region References

using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using gov.va.med.vbecs.Common;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

#endregion

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/25/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data Access component providing functionality for
	///	transfusion reaction count report
	///</summary>

	#endregion

	public class TransfusionReactionReport
	{
		#region Static Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5853"> 
		///		<ExpectedInput>start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5854"> 
		///		<ExpectedInput>Invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetSummaryDataForReport
		/// </summary>
		public static DataSet GetSummaryDataForReport(DateTime startDate, DateTime endDate)
		{
			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}
			return GetReportDataSet(startDate, endDate, STOREDPROC.GetReportTransfusionReactionCountSummary.StoredProcName);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5855"> 
		///		<ExpectedInput>Valid start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5856"> 
		///		<ExpectedInput>Invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetSummaryDataForReportAllDivisions
		/// </summary>
		public static DataSet GetSummaryDataForReportAllDivisions(DateTime startDate, DateTime endDate)
		{
			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}
			return GetReportDataSet(startDate, endDate, STOREDPROC.GetReportTransfusionReactionCountSummaryMultidivisional.StoredProcName);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5857"> 
		///		<ExpectedInput>Valid start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5858"> 
		///		<ExpectedInput>Invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetDetailedDataForReport
		/// </summary>
		public static DataSet GetDetailedDataForReport(DateTime startDate, DateTime endDate)
		{
			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}
			return GetReportDataSet(startDate, endDate, STOREDPROC.GetReportTransfusionReactionCountDetails.StoredProcName);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5859"> 
		///		<ExpectedInput>Valid start date, end date</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5860"> 
		///		<ExpectedInput>Invalid start date, end date</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetDetailedDataForReportAllDivisions
		/// </summary>
		public static DataSet GetDetailedDataForReportAllDivisions(DateTime startDate, DateTime endDate)
		{
			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}
			return GetReportDataSet(startDate, endDate, STOREDPROC.GetReportTransfusionReactionCountDetailsMultidivisional.StoredProcName);
		}

		#endregion

		#region Helper Methods

		/// <summary>
		/// Retrieves a DataSet for a particular Transfusion 
		/// Reaction Count report type.
		/// Note: we use "GetReportTransfusionReactionCountSummary", 
		/// however, all the calling methods stored procedures use
		/// the same parameters.
		/// </summary>
		private static DataSet GetReportDataSet(DateTime startDate, DateTime endDate, string storedProcedureName)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetReportTransfusionReactionCountSummary.startdate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetReportTransfusionReactionCountSummary.enddate, SqlDbType.DateTime),
									  new SqlParameter(STOREDPROC.GetReportTransfusionReactionCountSummary.divisioncode, SqlDbType.Char)
								  };

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(storedProcedureName, prms);
		}

		#endregion
	}
}
